-- various functions for doing things by gametype.
-- some of this previously appeared in 03 SystemDirection.

-- GetComboThresholds()
ComboThresholdTable = {
	dance	=	{ Maintain = "TapNoteScore_W3", Continue = GAMESTATE:GetPlayMode() == "PlayMode_Oni" and "TapNoteScore_W2" or "TapNoteScore_W3" },
	pump	=	{ Maintain = "TapNoteScore_W4", Continue = "TapNoteScore_W4" },
	techno	=	{ Maintain = "TapNoteScore_W3", Continue = "TapNoteScore_W3" },
	kb7		=	{ Maintain = "TapNoteScore_W4", Continue = "TapNoteScore_W4" },
	-- these values are chosen to match Deluxe's PARASTAR:
	para	=	{ Maintain = "TapNoteScore_W5", Continue = "TapNoteScore_W3" },
};

function GetComboThreshold()
	local CurrentGame = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	return ComboThresholdTable[CurrentGame];
end;

-- hardcoded to only happen on beat/pop'n
function GetPenalizeTapScore()
	local CurrentGame = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	return (CurrentGame == "beat" or CurrentGame == "popn") and true or false;
end;

local StyleTypesPerGame = {
	dance	= "Single,Solo,Double,Versus",
	pump	= "Single,Double,Versus",
	kb7		= "Single",
	--------------------------------------
	--[[
	techno	= "",
	beat	= "",
	para	= "",
	popn	= "",
	--]]
	--------------------------------------
	default	= "Single",
}
function GetStyleTypesForGame()
	local game = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	if StyleTypesPerGame[game] then
		return StyleTypesPerGame[game]
	end
	return StyleTypesPerGame["default"]
end

local DefaultGameStyle = {
	dance	= "Single",
	pump	= "Single",
	kb7		= "Single",
	--------------------------------------
	--[[
	techno	= "",
	beat	= "",
	para	= "",
	popn	= "",
	--]]
	--------------------------------------
	default	= "Single",
}
function GetDefaultSelStyleChoice()
	local game = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	if DefaultGameStyle[game] then
		return DefaultGameStyle[game]
	end
	return DefaultGameStyle["default"]
end